
call spQuery_Unidad_Medida('UND',NULL,'','');

DROP PROCEDURE IF EXISTS spQuery_Unidad_Medida;
CREATE PROCEDURE spQuery_Unidad_Medida(	
  varCodigo   varchar(10),
	varNombre   varchar(80),
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadUsr  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_um = '", varCodigo, "' ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_um AS CUM, M.nombre AS DESCRIPCION, ",
                    "(select count(id_um_destino) as total from _sv_factor_conv where id_um_origen = M.id_um) as CANT, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_unid_medida M ",
                    "left join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' ",
	                  varCadCod, varCadNom,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;