call spQuery_Sueldo_General_Vendedor(1, 6, '2012', '08', '2012-08-01', '2012-08-31'); 	

DROP PROCEDURE IF EXISTS spQuery_Sueldo_General_Vendedor;
CREATE PROCEDURE spQuery_Sueldo_General_Vendedor(
  varEmpresa    int,
  varVendedor   int,
	varAnio       varchar(4),
  varMes        varchar(4),  
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN
  select V.CVEN, V.VENDEDOR, V.VENTA, V.COMISION, M.CUOTA, 
  ROUND(VENTA/CUOTA*100,2) AS LOGRO,
  ifnull(ROUND((ifnull(VENTA,0)/IFNULL(CUOTA,0))*IFNULL(BASICO,0),2),0) as BASICO,
  ROUND(IFNULL(V.COMISION,0),2) + ifnull(ROUND((ifnull(VENTA,0)/IFNULL(CUOTA,0))*IFNULL(BASICO,0),2),0) AS SUELDO

  from
    (
    select CVEN, VENDEDOR, BASICO, SUM(VENTA) AS VENTA, SUM(VENTA*PESO/100) AS COMISION
    from
      (
      select V.id_trabajador as CVEN, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ', V.nombre) as VENDEDOR,
      A.id_proveedor as CPRO, C.id_lista as CTIP,
      V.sueldo_base_mensual as BASICO,
      sum(D.subtotal) as VENTA
      from _sv_venta_detalle D
      inner join _sv_venta C    ON D.id_venta    = C.id_venta
      inner join _sv_producto A ON D.id_producto = A.id_producto      
      inner join _sv_trabajador V ON C.id_trabajador = V.id_trabajador
      where C._estado = 'A'
      and D._estado = 'A'
      and C.estado <> 'AN'
      and C.fecha_emision >= varFechaIni
      and C.fecha_emision <= varFechaFin
      and C.id_trabajador  = varVendedor
      and C.id_empresa     = varEmpresa
      GROUP BY V.id_trabajador, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ', V.nombre), A.id_proveedor, C.id_lista, V.sueldo_base_mensual
      ) A
    left join
      (
      select C.id_proveedor as CPRO, C.id_lista as CTIP,
      sum(C.peso) as PESO
      from _sv_proveedor_comision C
      where C._estado   = 'A'
      and C.id_anio     = varAnio
      and C.id_mes      = varMes
      and C.id_empresa  = varEmpresa
      group by C.id_proveedor, C.id_lista
      ) B
    on A.CPRO = B.CPRO AND A.CTIP = B.CTIP
    GROUP BY CVEN, VENDEDOR, BASICO
    ) V
  left join
    (
    select M.id_trabajador as CVEN, sum(M.monto) as CUOTA 
    from _sv_cuota_venta_vendedor M
    where M.id_anio   = varAnio
    and M.id_mes      = varMes
    and M.id_empresa  = varEmpresa
    and M.id_trabajador = varVendedor
    and M._estado   = 'A'
    group by M.id_trabajador
    ) M
  ON V.CVEN = M.CVEN ;
END;
