call spQuery_Sueldo_Detallado(1, 3, '2012', '08', '2012-09-01', '2012-09-26');

DROP PROCEDURE IF EXISTS spQuery_Sueldo_Detallado;
CREATE PROCEDURE spQuery_Sueldo_Detallado( 
  varEmpresa    int,
  varVendedor   int,
	varAnio       varchar(4),
  varMes        varchar(4),
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN
  DECLARE varTipoVen int;
  
  select V.CPRO, PROVEEDOR, 
  ROUND(VENTA,2) AS VENTA, 
  ROUND(CUOTA,2) AS CUOTA, 
  ROUND(VENTA/CUOTA*100,2) AS LOGRO, 
  COMISION
  from
    (
    SELECT A.CPRO, A.PROVEEDOR,
    SUM(IFNULL(A.VENTA,0)) AS VENTA, 
    SUM(IFNULL(A.VENTA,0)*IFNULL(B.PESO,0)/100) AS COMISION
    FROM
      (
      select A.id_proveedor as CPRO, P.nombre as PROVEEDOR, V.id_lista AS CLIS,
      sum(round(D.subtotal,2)) as VENTA,
      sum(round(D.total,2)) as TOTAL
      from _sv_venta_detalle D
      inner join _sv_venta V      ON D.id_venta = V.id_venta
      inner join _sv_producto A   ON D.id_producto = A.id_producto
      inner join _sv_proveedor P  ON A.id_proveedor = P.id_proveedor
      where V.estado <> 'AN'
      and V._estado = 'A' and D._estado = 'A'
      and D.subtotal > 0
      and V.id_empresa     = varEmpresa
      and V.id_trabajador  = varVendedor
      and V.fecha_emision >= varFechaIni
      and V.fecha_emision <= varFechaFin
      GROUP BY A.id_proveedor, P.nombre, V.id_lista
      ) A
    LEFT JOIN
      (
      select C.id_proveedor as CPRO, C.id_lista as CLIS, C.PESO
      from _sv_proveedor_comision C
      where C._estado = 'A'
      and C.id_anio = varAnio
      and C.id_mes  = varMes
      ) B
    ON A.CPRO = B.CPRO AND A.CLIS = B.CLIS
    GROUP BY A.CPRO, A.PROVEEDOR
    ) V
  LEFT JOIN
    (
    select M.id_proveedor as CPRO,
    sum(M.monto) as CUOTA 
    from _sv_cuota_venta_vendedor M
    where M.id_anio   = varAnio
    and M.id_mes      = varMes
    and M.id_trabajador = varVendedor
    and M._estado     = 'A'
    group by M.id_proveedor
    ) M
  ON V.CPRO = M.CPRO;
END;
