call spQuery_Sistema_Rol_Menu(1, 1,1);
call spQuery_Sistema_Rol_Menu(4, 1, 1)

DROP PROCEDURE IF EXISTS spQuery_Sistema_Rol_Menu;
CREATE PROCEDURE spQuery_Sistema_Rol_Menu(
  varSistema  int,
	varRol      int,
  varUsuario  int
)
BEGIN
  if varUsuario=1 then
    select M.id_menu, M.nombre, M.img_out, M.img_over,
    case when U.id_menu then 'SI' else 'NO' end as permite
    from
      (
      select id_sistema, id_menu, nombre,
      concat('<img src="',(select valor from _sys_config where ide='01'), img_out,'" width=16 height=16 border="0" />') as img_out,
      concat('<img src="',(select valor from _sys_config where ide='01'), img_over,'" width=16 height=16 border="0" />') as img_over, link
      from _sys_menu 
      where _estado  = 'A'
      and id_sistema = varSistema
      ) M
    left join
      (
      select id_sistema, id_menu
      from _sys_rol_menu
      where id_rol   = varRol
      and id_sistema = varSistema
      ) U
    on M.id_sistema = U.id_sistema and M.id_menu = U.id_menu
    order by M.id_menu;
  else
     select M.id_menu, M.nombre, M.img_out, M.img_over,
      case when U.id_menu then 'SI' else 'NO' end as permite
      from
        (
        select id_sistema, id_menu, nombre,
        concat('<img src="',img_out,'" width=16 height=16 border="0" />') as img_out,
        concat('<img src="',img_over,'" width=16 height=16 border="0" />') as img_over, link
        from _sys_menu         
        where _estado  = 'A'
        and id_sistema = varSistema
        and id_menu   <> '010101'
        ) M
      left join
        (
        select id_sistema, id_menu
        from _sys_rol_menu
        where id_rol   = varRol
        and id_sistema = varSistema
        ) U
      on M.id_sistema = U.id_sistema and M.id_menu = U.id_menu
      order by M.id_menu;
  end if;
END;