call spQuery_Registro_Pedidos_Cambios(2, NULL, NULL, NULL, NULL, '2014-01-01', '2014-01-11', 'IN', NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Registro_Pedidos_Cambios;
CREATE PROCEDURE spQuery_Registro_Pedidos_Cambios(  
	varEmpresa  int,
  varAgencia  int,
	varVendedor int,
  varCliente  int,
  varRuta     varchar(10),
	varFechaIni date,
	varFechaFin date,
  varEstado   varchar(2),
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN  
  DECLARE varCadEmp, varCadAge, varCadVen, varCadCli, varCadRut, varCadIni, varCadFin, varCadEst TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  IF IFNULL(varEmpresa,0) <> 0 THEN
    SET varCadEmp = CONCAT(" and C.id_empresa = ", varEmpresa, " ");  
  END IF;
  
  IF IFNULL(varAgencia,0) <> 0 THEN
    SET varCadAge = CONCAT(" and C.id_agencia = ", varAgencia, " ");  
  END IF;
  
  IF IFNULL(varVendedor,0) <> 0 THEN
    SET varCadVen = CONCAT(" and C.id_trabajador = ", varVendedor, " ");  
  END IF;
  
  IF IFNULL(varCliente,0) <> 0 THEN
    SET varCadCli = CONCAT(" and C.id_cliente = ", varCliente, " ");  
  END IF;
  
  IF varRuta <> '' and varRuta is not null THEN
    SET varCadRut = CONCAT(" and C.id_ruta = '", varRuta, "' ");  
  END IF;
  
  IF varFechaIni IS NOT NULL THEN
    SET varCadIni = CONCAT(" and C.fecha_pedido >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin IS NOT NULL THEN
    SET varCadFin = CONCAT(" and C.fecha_pedido <= '", varFechaFin, "' ");
  END IF;
  
  IF varEstado <> '' and varEstado is not null THEN
    SET varCadEst = CONCAT(" and C.estado = '", varEstado, "' ");  
  END IF;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  set @sql = CONCAT("select C.id_pedido as IDE, ",
                    "C.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "C.id_agencia as CAGE, A.nombre as AGENCIA, ",
                    "C.id_almacen as CALM, K.nombre as ALMACEN, ",
                    "date_format(C.fecha_pedido,'%d/%m/%Y') AS FECHA, ",
                    "C.id_tipo_doc as CTIP, T.nombre as TIPO, ",
                    "C.id_condicion as CCON, TC.nombre as CONDICION, ",
                    "CASE WHEN C.estado='AN' THEN 'ANULADO'   ",
                    "     WHEN C.estado='IN' THEN 'INGRESADO' ",
                    "     WHEN C.estado='FA' THEN 'FACTURADO' ",
                    "END AS ESTADO, ",                                   
                    "LPAD(C.id_cliente,6,'0') as CCLI, P.nombre as CLIENTE, ",
                    "LPAD(C.id_trabajador,8,'0') as CVEN, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ', V.nombre) as VENDEDOR, ",
                    "P.id_ruta as CRUT, R.nombre as RUTA, ", 
                    "C.id_lista as CLIS, L.nombre as LISTA, ",
                    "C.nro_pedido as PEDIDO, "
                    "C.TOTAL, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_pedido C ",
                    "inner join _sv_empresa E         ON C.id_empresa = E.id_empresa ",
                    "inner join _srh_agencia A         ON C.id_agencia = A.id_agencia ",
                    "inner join _sv_almacen K         ON C.id_almacen = K.id_almacen ",
                    "inner join _sv_cliente P         ON C.id_Cliente = P.id_Cliente ",
                    "inner join _sv_ruta R            ON P.id_ruta = R.id_ruta ",
                    "inner join _sv_lista L           ON C.id_empresa = L.id_empresa and C.id_lista = L.id_lista ",  
                    "inner join _sv_tipo_doc_venta T  ON C.id_tipo_doc = T.id_tipo_doc "
                    "inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion ",
                    "inner join _sv_trabajador V      ON C.id_trabajador = V.id_trabajador ",
                    "inner join _sys_usuario UN       ON C._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU       ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
                    "and T.flag_cambio = 'S' ",
                    varCadEmp, varCadAge, varCadVen, varCadCli, varCadRut, varCadIni, varCadFin, varCadEst,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;