CALL spQuery_Registro_Compras_Cabecera(1);

DROP PROCEDURE IF EXISTS spQuery_Registro_Compras_Cabecera;
CREATE PROCEDURE spQuery_Registro_Compras_Cabecera(  
	varCompra    int
  )
BEGIN 
  select C.id_compra as IDE,
  date_format(C.fecha_emision,'%d/%m/%Y') AS FEMI, 
  date_format(C.fecha_movimiento,'%d/%m/%Y') AS FMOV,
	T.nombre AS CTIP, C.nro_documento AS NDOC,
	C.id_proveedor AS CPRO, P.nombre AS PROVEEDOR, P.RUC, 
  C.id_condicion AS CCON, Co.nombre as CONDICION,
	C.SUBTOTAL, C.IGV,  C.TOTAL, 
  ifnull(C.total,2) - ifnull(C.saldo,0) as PAGOS , C.SALDO,
  C.ESTADO,
	UPPER(UC.usuario) as USER_CREATE,
  date_format(C._date_create,'%d/%m/%Y %h:%m:%s %p') AS DATE_CREATE,
  UPPER(UU.usuario) AS USER_UPDATE,
  date_format(C._date_update,'%d/%m/%Y %h:%m:%s %p') AS DATE_UPDATE
	from _sv_compra C
	inner join _sv_proveedor P ON C.id_proveedor = P.id_proveedor
	inner join _sv_tipo_doc_compra T ON C.id_tipo_doc = T.id_tipo_doc
  inner join _sv_tipo_condicion Co ON C.id_condicion = Co.id_condicion
  left join _sys_usuario UC  ON C._user_create = UC.id_usuario
  left join _sys_usuario UU  ON C._user_update = UU.id_usuario
	where C._estado = 'A'
	AND C.id_compra = varCompra;
END;