call spQuery_Producto_Familia(NULL,'','Ninguno','',NULL);

DROP PROCEDURE IF EXISTS spQuery_Producto_Familia;
CREATE PROCEDURE spQuery_Producto_Familia(
  varCodigo varchar(4),
	varNombre varchar(60),
  varTipo   varchar(10),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadTip  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_familia = ", varCodigo, " ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  
  if varTipo is not null and varTipo <> '' and varTipo <> 'Ninguno' then
    set varCadTip = CONCAT(" and M.id_tipo = '", varTipo, "' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_familia AS CFAM, M.nombre AS FAMILIA, ",
                    "M.id_tipo as CLIN, T.nombre as LINEA, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_familia M ",
                    "inner join _sv_tipo T ON M.id_tipo = T.id_tipo "                    
                    "inner join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' and M.id_familia <> 0 ",
	                  varCadCod, varCadNom, varCadTip,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;