DROP PROCEDURE IF EXISTS spQuery_Planificador;
CREATE PROCEDURE spQuery_Planificador(
	varAnioCM  varchar(4),
	VarMesCM   varchar(4),
	varDia date,
	varTipo varchar(5),
	varCd varChar(2)
)
BEGIN
 	declare varFech1 date;
 	declare varFech2 date;
 	declare varFech3 date;

	set varFech1=Date_format(DATE_SUB(varDia,INTERVAL 7 DAY) ,'%Y-%m-%d');
	set varFech2=Date_format(DATE_SUB(varFech1,INTERVAL 7 DAY) ,'%Y-%m-%d');
	set varFech3=Date_format(DATE_SUB(varFech2,INTERVAL 7 DAY) ,'%Y-%m-%d');
	
 	if varTipo = 'Todos' then
		select A.CVEN, A.VENDEDOR, A.CMAR, A.MARCA, A.CTAM, A.TAMANO, 
    A.FCON, B.VOL_ACU, PAQ_ACU,
    A.VOL_ANT, A.PAQ_ANT, date_format(varFech3 ,'%d/%m/%Y') as FECHA_ANT,
    A.VOL_PEN, A.PAQ_PEN, date_format(varFech2 ,'%d/%m/%Y') as FECHA_PEN,
    A.VOL_ULT, A.PAQ_ULT, date_format(varFech1 ,'%d/%m/%Y') as FECHA_ULT
		from
		(
			select IFNULL(CM.id_vendedor,CONCAT(C.id_cd,'000')) as CVEN, IFNULL(V.nombre,'SIN VENDEDOR') as VENDEDOR,
			A.id_marca as CMAR, M.nombre as MARCA,
			A.id_tamano as CTAM, T.nombre as TAMANO,
			A.factor_hl as FCON,
			sum(case when C.FEMI=varFech1 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_ULT,
			sum(case when C.FEMI=varFech1 then D.QCANPED/A.bot_paquete end) as PAQ_ULT,
			sum(case when C.FEMI=varFech2 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_PEN,
			sum(case when C.FEMI=varFech2 then D.QCANPED/A.bot_paquete end) as PAQ_PEN,
			sum(case when C.FEMI=varFech3 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_ANT,
			sum(case when C.FEMI=varFech3 then D.QCANPED/A.bot_paquete end) as PAQ_ANT
			from _sv_fact_ventas_det_2011 D
			inner join _sv_fact_ventas_cab_2011 C ON D.id_empresa = C.id_empresa AND D.id_tipo_doc = C.id_tipo_doc AND D.nro_documento = C.nro_documento
			inner join _sv_articulo A     ON D.id_articulo = A.id_articulo
			inner join _sv_marca M        ON A.id_marca = M.id_marca
			inner join _sv_tamano T       ON A.id_tamano = T.id_tamano
			inner join _sv_cliente_mes CM ON C.id_cliente = CM.id_cliente
			inner join _sv_vendedor V     ON CM.id_vendedor = V.id_vendedor
			where C.CESDOC = '04'
			and C.id_tipo_doc <> 6 
			and IFNULL(A.flag_comodato,'N') <> 'S'
			and CM.id_anio  = varAnioCM
			and CM.id_mes   = varMesCM
			and C.id_cd = varCd
			-- and V.id_supervisor= varOpcion
			and D.CTIPVT not in ('012','013')
			and C.FEMI in (varFech1,varFech2,varFech3)
			group by IFNULL(CM.id_vendedor,CONCAT(C.id_cd,'000')), IFNULL(V.nombre,'SIN VENDEDOR'), A.id_marca, M.nombre, A.id_tamano, T.nombre, A.factor_hl
		) A
		
		left join
		(
			select IFNULL(CM.id_vendedor,CONCAT(H.id_cd,'000')) as CVEN,
			H.id_marca as CMAR, H.id_tamano as CTAM,
			sum(H.qhl_venta) as VOL_ACU,
			sum(H.qpaq_venta) as PAQ_ACU
			from _sv_fact_historico_sku H
			inner join _sv_cliente_mes CM ON H.id_cliente = CM.id_cliente
			inner join _sv_vendedor V ON CM.id_vendedor = V.id_vendedor
			where CM.id_anio = varAnioCM
			and CM.id_mes    = varMesCM
			and CM.id_cd     = varCd
			and H.id_cd      = varCd
			-- and V.id_supervisor= varOpcion
			group by IFNULL(CM.id_vendedor,CONCAT(H.id_cd,'000')), H.id_marca, H.id_tamano
		) B
		ON A.CVEN = B.CVEN and A.CMAR = B.CMAR AND A.CTAM = B.CTAM
		ORDER BY A.CVEN, A.CMAR, A.CTAM;
	else
		select A.CVEN, A.VENDEDOR, A.CMAR, A.MARCA, A.CTAM, A.TAMANO, A.FCON, B.VOL_ACU, PAQ_ACU,A.VOL_ANT, A.PAQ_ANT,varFech3,A.VOL_PEN, A.PAQ_PEN,varFech2,A.VOL_ULT,A.PAQ_ULT,varFech1	
		from
		(
			select IFNULL(CM.id_vendedor,CONCAT(C.id_cd,'000')) as CVEN, IFNULL(V.nombre,'SIN VENDEDOR') as VENDEDOR,
			A.id_marca as CMAR, M.nombre as MARCA,
			A.id_tamano as CTAM, T.nombre as TAMANO,
			A.factor_hl as FCON,
			sum(case when C.FEMI=varFech1 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_ULT,
			sum(case when C.FEMI=varFech1 then D.QCANPED/A.bot_paquete end) as PAQ_ULT,
			sum(case when C.FEMI=varFech2 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_PEN,
			sum(case when C.FEMI=varFech2 then D.QCANPED/A.bot_paquete end) as PAQ_PEN,
			sum(case when C.FEMI=varFech3 then D.QCANPED/A.bot_paquete*A.factor_hl end) as VOL_ANT,
			sum(case when C.FEMI=varFech3 then D.QCANPED/A.bot_paquete end) as PAQ_ANT
			from _sv_fact_ventas_det_2011 D
			inner join _sv_fact_ventas_cab_2011 C ON D.id_em