
CALL spQuery_Mov_Almacen('2010','08','09','0942');

DROP PROCEDURE IF EXISTS db_bebidas.spQuery_Mov_Almacen;
CREATE PROCEDURE db_bebidas.`spQuery_Mov_Almacen`(
  varAnio     varchar(4),
  varMes      varchar(2),
  varCD       varchar(2),
  varAlmacen  varchar(5)
  )
BEGIN
  /* ALMACEN
  40 liquido
  42 averias
  43 pop
  50 envases
  */
  DECLARE varFechaIni DATE DEFAULT STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  DECLARE varFechaFin DATE DEFAULT LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y'));
  DECLARE varOperacion, varTipo varchar(5);
	DECLARE varSQLIng, varSQLSal text DEFAULT '';  
  DECLARE done INT DEFAULT 0;  
  
	DECLARE cur1 CURSOR FOR    
      
      order by T.tipo, M.id_movimiento

        select distinct id_operacion,
        case when M.id_operacion LIKE '1%' then 'I' else 'S' end as tipo
        from _sv_fact_mov_almacen M
        where  id_cd = varCD 
        and id_almacen = varAlmacen
        and FMOV >= varFechaIni
        and FMOV <= varFechaFin
        ORDER BY id_operacion;
     
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;

	OPEN cur1;
	REPEAT
    FETCH cur1 INTO varOperacion, varTipo;
		IF NOT done THEN
      if varTipo = 'I' then        
        SET varSQLIng = CONCAT(varSQLIng, "sum(case when id_operacion='", varOperacion, "' then QTOTAL end) as QCAN_", varOperacion, ", ");
      elseif varTipo = 'S' then  
        set varSQLSal = CONCAT(varSQLSal, "sum(case when id_operacion='", varOperacion, "' then QTOTAL end) as QCAN_", varOperacion, ", ");
      end if;      
    END IF;
  	UNTIL done END REPEAT;
  CLOSE cur1;
  
  SET @sql = CONCAT("select id_articulo as CART, descripcion as ARTICULO, BOT, ",
                    "sum(case when id_operacion='INI' then QTOTAL end) as QCAN_INICIAL, ", varSQLIng, 
                    "sum(case when substring(id_operacion,1,1) = '1' then QTOTAL end) QCAN_INGRESOS, ", varSQLSal,
                    "sum(case when substring(id_operacion,1,1) = '2' then QTOTAL end) QCAN_SALIDAS, ",
                    "sum(case when substring(id_operacion,1,1) = '1' then QTOTAL ",
                    "        when substring(id_operacion,1,1) = '2' then QTOTAL*-1 ",
                    "        else QTOTAL end)  AS QCAN_STOCK ",
                    "FROM ",
                    "  ( ",
                    "  select M.id_articulo, A.descripcion, A.bot_paquete as BOT, 'INI' AS id_operacion, ",
                    "  round(sum(round(ifnull(case when substring(M.id_operacion,1,1) = '1' then M.QTOTAL else M.QTOTAL*-1 end,0),0)*A.bot_paquete + (ifnull(case when M.id_operacion like '1%' then M.QTOTAL else M.QTOTAL*-1 end,0) - round(ifnull(case when substring(M.id_operacion,1,1) = '1' then M.QTOTAL else M.QTOTAL*-1 end,0),0))*100),2) as QTOTAL ",
                    "  from _sv_fact_mov_almacen M ",
                    "  inner join _sv_articulo A ON M.id_articulo = A.id_articulo ",
                    "  where M.id_cd = '", varCD,"' ",
                    "  and M.id_almacen = '", varAlmacen,"' ",
                    "  and M.FMOV < '", varFechaIni, "' ",
                    "  group by M.id_articulo, A.descripcion, A.bot_paquete ",
                    "  having round(sum(round(ifnull(case when substring(M.id_operacion,1,1) = '1' then M.QTOTAL else M.QTOTAL*-1 end,0),0)*A.bot_paquete + (ifnull(case when M.id_operacion like '1%' then M.QTOTAL else M.QTOTAL*-1 end,0) - round(ifnull(case when substring(M.id_operacion,1,1) = '1' then M.QTOTAL else M.QTOTAL*-1 end,0),0))*100),2) <> 0 ",
                    "  UNION ",
                    "  select M.id_articulo, A.descripcion, A.bot_paquete as BOT, M.id_operacion, ",
                    "  sum(round(ifnull(M.QTOTAL,0),0)*A.bot_paquete + (ifnull(M.QTOTAL,0) - round(ifnull(M.QTOTAL,0),0))*100) as QTOTAL ",
                    "  from _sv_fact_mov_almacen M ",
                    "  inner join _sv_articulo A ON M.id_articulo = A.id_articulo ",
                    "  where M.id_cd = '", varCD,"' ",
                    "  and M.id_almacen = '", varAlmacen,"' ",
                    "  and M.FMOV >= '", varFechaIni, "' ",
                    "  and M.FMOV <= '", varFechaFin, "' ",
                    "  group by M.id_articulo, A.descripcion, A.bot_paquete, M.id_operacion ",
                    "  ) A ",
                    "GROUP BY id_articulo, descripcion, BOT ",
                    "ORDER BY descripcion");
  
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;