call spQuery_Logisitica_Inventario_Vendedor('T',1);

DROP PROCEDURE IF EXISTS spQuery_Logisitica_Inventario_Vendedor;
CREATE PROCEDURE spQuery_Logisitica_Inventario_Vendedor(
  varTipoProducto char(1),
  varAlmacen      int
  )
BEGIN
  if varTipoProducto='T' then
    select P.id_proveedor as CLIN,
    L.nombre as LINEA,
    P.id_producto as CPRO, 
    P.descripcion as PRODUCTO, 
    P.id_um_stock as UM,    
    K.cantidad    as STOCK,
    P.precio_venta  as PRE_VENTA
    from _sv_kardex K
    inner join _sv_producto P on K.id_producto = P.id_producto
    inner join _sv_proveedor L on P.id_proveedor = L.id_proveedor
    inner join _sv_tipo T ON P.id_tipo = T.id_tipo
    inner join _sv_marca M ON P.id_marca = M.id_marca
    inner join _sv_material MT ON P.id_material = MT.id_material
    where P._estado  = 'A'
    and K._estado    = 'A'
    and K.id_almacen = varAlmacen;
  else
    select P.id_proveedor as CLIN,
    L.nombre as LINEA,
    P.id_producto as CPRO,
    P.descripcion as PRODUCTO, 
    P.id_um_stock as UM,
    K.cantidad as STOCK,
    P.precio_venta  as PRE_VENTA
    from _sv_kardex K
    inner join _sv_producto P on K.id_producto = P.id_producto
    inner join _sv_proveedor L on P.id_proveedor = L.id_proveedor
    inner join _sv_tipo T ON P.id_tipo = T.id_tipo
    inner join _sv_marca M ON P.id_marca = M.id_marca
    inner join _sv_material MT ON P.id_material = MT.id_material
    where P._estado  = 'A'
    and K._estado    = 'A'
    and K.id_almacen = varAlmacen
    and K.cantidad   > 0;
  end if;
END;