call spQuery_Lista_Servicio('000102',NULL);

DROP PROCEDURE IF EXISTS spQuery_Lista_Servicio;
CREATE PROCEDURE spQuery_Lista_Servicio(	
	varCodigo varchar(6),
  varNombre varchar(80)
)
BEGIN
  DECLARE varCadCod, varCadNom TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and P.id_producto = '", lpad(varCodigo,6,'0'),"' ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and P.descripcion like '%", varNombre,"%' ");
  end if;

 	SET @sql = CONCAT("SELECT A.CPRO, A.PRODUCTO, UM_VENTA, UM_COMPRA, UM_STOCK, IFNULL(STOCK,0) AS STOCK ",
                    "FROM ",
                    "  ( ",
                    "  select P.id_producto AS CPRO, P.descripcion AS PRODUCTO, ",
                    "  P.id_um_venta AS UM_VENTA, P.id_um_compra AS UM_COMPRA, P.id_um_stock as UM_STOCK ",                     
                    "  from _sv_producto P ",
                    "  inner join _sv_tipo T ON P.id_tipo = T.id_tipo ",
                    "  WHERE P._estado = 'A' ",
                    "  and T.flag_proser = 'S' ",
                    varCadCod, varCadNom,
                    "  ) A ",
                    "LEFT JOIN ",
                    "  ( ",
                    "  select K.id_producto as CPRO, ",
                    "  case when F.operacion = '*' then K.cantidad*F.factor ",
                    "       when F.operacion = '/' then K.cantidad/F.factor ",
                    "  end STOCK ",
                    "  from _sv_kardex K ",
                    "  inner join _sv_producto P ON K.id_producto = P.id_producto ",
                    "  inner join _sv_factor_conv F ON P.id_um_stock = F.id_um_origen and P.id_um_venta = F.id_um_destino ",
                    "  where K._estado  = 'A' ",
                    "  and K.id_almacen = 1 ",     
                    "  ) B ",
                    "ON A.CPRO = B.CPRO; "); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;