call spQuery_CXP_Registro_Compras(NULL, 0, NULL, NULL, NULL, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_CXP_Registro_Compras;
CREATE PROCEDURE spQuery_CXP_Registro_Compras(
  varEmpresa    int,
	varProveedor  int,
  varTipoDoc    int,
	varFechaIni   date,
	varFechaFin   date,
  varEstado     char(2),
  varField      varchar(60),
  varOrder      varchar(5)
  )
BEGIN  
  DECLARE varCadEmp, varCadIni, varCadFin, varCadPro, varCadTip, varCadEst varchar(100) DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  IF varEmpresa is not null THEN
    SET varCadEmp = CONCAT(" and C.id_empresa = ", varEmpresa, " ");  
  END IF;
  IF varProveedor is not null THEN
    SET varCadPro = CONCAT(" and C.id_proveedor = ", varProveedor, " ");  
  END IF;
  if varTipoDoc is not null then
    set varCadTip = CONCAT(" and C.id_tipo_doc = ", varTipoDoc," ");
  end if;  
  IF varFechaIni IS NOT NULL THEN
    SET varCadIni = CONCAT(" and C.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  IF varFechaFin IS NOT NULL THEN
    SET varCadFin = CONCAT(" and C.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  IF varEstado IS NOT NULL THEN
    SET varCadEst = CONCAT(" and C.estado = '", varEstado, "' ");
  END IF;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  set @sql = CONCAT("select C.id_compra as IDE, ",
                    "C.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "date_format(C.fecha_emision,'%d/%m/%Y') AS FECHA, ",
                    "C.id_tipo_doc as CTIP, T.nombre as TIPO_DOC, ",
                    "C.nro_documento as DOCUMENTO, ",
                    "C.ESTADO, ",                                        
                    "C.id_proveedor as CPRO, P.nombre as PROVEEDOR, ",
                    "C.SUBTOTAL, C.IGV, C.TOTAL, ", 
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_compra C ",
                    "inner join _sv_empresa E ON C.id_empresa = E.id_empresa ",
                    "inner join _sv_proveedor P ON C.id_proveedor = P.id_proveedor ",
                    "inner join _sv_tipo_doc_compra T ON C.id_tipo_doc = T.id_tipo_doc ",
                    "left join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
                    varCadEmp, varCadPro, varCadIni, varCadFin, varCadTip, varCadEst,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
