call spQuery_Bonificacion(3,null, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Bonificacion;
CREATE PROCEDURE spQuery_Bonificacion(
  varEmpresa  int,
  varCodigo   int,
	varNombre   varchar(50),
  varEstado   char(1),
  varUsuario  int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadEst, varCadEmp  TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and B.id_bonif = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and B.nombre like '%", varNombre,"%' ");
  end if;
  if varEmpresa <> '' and varEmpresa is not null then
    set varCadEmp = CONCAT(" and B.id_empresa = ", varEmpresa," ");
  end if;
  if varEstado <> '' and varEstado is not null then
    set varCadEst = CONCAT(" and B.estado = '", varEstado,"' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  update _sv_bonificacion set estado = case when date_format(fecha_fin,'%Y-%m-%d')<date_format(now(),'%Y-%m-%d') then 'I' else estado end;
  
  SET @sql = CONCAT("select B.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "B.id_bonif as CBON, B.nombre as BONIFICACION, ",
                    "B.id_tipo_bonif as CTIP, T.nombre as TIPO, ",
                    "cast(CASE WHEN B.id_tipo_bonif='P' THEN B.id_lista ",
                    "    WHEN B.id_tipo_bonif='R' THEN B.id_ruta ",
                    "END as char) COPT, ",
                    "CASE WHEN B.id_tipo_bonif='P' THEN L.nombre ",
                    "    WHEN B.id_tipo_bonif='R' THEN R.nombre ",
                    "END as OPCION, ",
                    "date_format(B.fecha_ini,'%d/%m/%Y') AS DESDE, ",
                    "date_format(B.fecha_fin,'%d/%m/%Y') AS HASTA, ",
                    "CASE WHEN B.estado='A' THEN 'ACTIVO' ELSE 'INACTIVO' END AS ESTADO, ",
                    "date_format(B._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(B._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_bonificacion B ",
                    "inner join _sv_empresa E on B.id_empresa=E.id_empresa ",
                    "inner join _sv_tipo_bonif T ON B.id_tipo_bonif = T.id_tipo_bonif ",
                    "left join _sv_lista L ON B.id_empresa = L.id_empresa AND B.id_lista = L.id_lista ",
                    "left join _sv_ruta R ON B.id_ruta = R.id_ruta ",
                    "left join _sys_usuario  UN ON B._user_create = UN.id_usuario ",
                    "left join _sys_usuario  UU ON B._user_update = UU.id_usuario ",
                    "where B._estado='A' ",
                    "and B.id_empresa in (select distinct id_empresa from _sys_usuario_almacen where id_usuario=",varUsuario ,") ",
                    varCadEmp, varCadCod, varCadNom, varCadEst,                                  
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;