call spQuery_Avance_Rebotes_Vendedor('','2011-08-01','2011-08-25');

DROP PROCEDURE IF EXISTS spQuery_Avance_Rebotes_Vendedor;
CREATE PROCEDURE spQuery_Avance_Rebotes_Vendedor(  	  
	varFechaIni   date,
	varFechaFin   date,
  varVendedor   int,
  varCliente    int
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadVendedor, varCadCliente TEXT DEFAULT '';
  
  IF varVendedor <> '' AND varVendedor IS NOT NULL THEN
    SET varCadVendedor = CONCAT(" and V.id_vendedor = ", varVendedor, " ");  
  END IF;
  
  IF varCliente <> '' AND varCliente IS NOT NULL THEN
    SET varCadCliente = CONCAT(" and V.id_cliente = ", varCliente, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni <> '0000-00-00' and varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and V.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin <> '0000-00-00' and varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and V.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  
  set @sql = CONCAT("select DATE_FORMAT(V.fecha_emision,'%d/%m/%Y') as FEMI, ",
                    "V.nro_pedido as PEDIDO, ",
                    "T.abrev as CTIP, V.nro_documento as NDOC, ",                    
                    "V.id_vendedor as CVEN, UPPER(P.nombre) as VENDEDOR, ",
                    "V.id_cliente as CCLI, UPPER(C.nombre) as CLIENTE, ",
                    "C.id_ruta as CRUT, UPPER(R.nombre) as RUTA, "
                    "CASE WHEN V.estado='AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado='AN' and V.id_motivo_rechazo=0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END AS ESTADO, "
                    "V.id_motivo_rechazo as CMOT, M.nombre as MOTIVO, ",
                    "sum(round(D.cantidad_ate*D.precio,2)) as TOTAL_GRAL, ",
                    "sum(CASE WHEN V.estado = 'AN' THEN round(D.cantidad_ate*D.precio,2) ",
                    "         ELSE round(D.cantidad_ate*D.precio,2) - D.total END) as RECHAZADO, ",
                    "sum(round(D.cantidad_ate*D.precio,2) - ",
                    "    CASE WHEN V.estado = 'AN' THEN round(D.cantidad_ate*D.precio,2) ",
                    "         ELSE round(D.cantidad_ate*D.precio,2) - D.total END) as EFECTIVO ",
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V ON D.id_venta = V.id_venta ",
                    "inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc ",
                    "inner join _sv_vendedor P ON V.id_vendedor = P.id_vendedor ",                    
                    "inner join _sv_cliente C ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R    ON C.id_ruta = R.id_ruta ",
                    "inner join _sv_motivo_rechazo M ON V.id_motivo_rechazo = M.id_motivo_rechazo ",
                    "where V._estado = 'A' ",
                    "and D._estado = 'A' ",
                    "and V.id_motivo_rechazo <> 0 ",
                    varCadVendedor, varCadCliente, varCadFechaIni, varCadFechaFin,
                    "group by DATE_FORMAT(V.fecha_emision,'%d/%m/%Y'), ", 
                    "V.nro_pedido, ",
                    "T.abrev, V.nro_documento, ",
                    "V.id_vendedor, P.nombre, ",                    
                    "V.id_cliente, C.nombre, ",
                    "C.id_ruta, R.nombre, ",
                    "CASE WHEN V.estado= 'AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END, "
                    "V.id_motivo_rechazo, M.nombre, ",
                    "V.total ",
                    "ORDER BY P.nombre, C.nombre, V.fecha_emision ");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;