DROP PROCEDURE IF EXISTS spMante_Tipo_Habitacion;
CREATE PROCEDURE spMante_Tipo_Habitacion(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
  varCapaci   int,
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sh_tipo_habitacion
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_tipo_habitacion),0)+1 INTO varCodigo FROM _sh_tipo_habitacion;
      INSERT INTO _sh_tipo_habitacion (id_tipo_habitacion, nombre, capacidad, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varCapaci, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE HABITACION ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sh_tipo_habitacion
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_tipo_habitacion <> varCodigo;
    if varExiste <= 0 then 
      update _sh_tipo_habitacion set
      nombre       = UPPER(varNombre), 
      capacidad    = varCapaci,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_habitacion = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE HABITACION ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;