call spMante_Tipo_Doc_Venta('NEW', NULL, 'BOLETA DE VENTAS','BOL', '03', 1);

DROP PROCEDURE IF EXISTS spMante_Tipo_Doc_Compra;
CREATE PROCEDURE spMante_Tipo_Doc_Compra(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
  varAbrev    varchar(20),
  varSunat    varchar(10),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_tipo_doc_compra
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_tipo_doc),0)+1 INTO varCodigo FROM _sv_tipo_doc_compra;
      INSERT INTO _sv_tipo_doc_compra (id_tipo_doc, nombre, abrev, cod_sunat, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varAbrev, varSunat, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL TIPO DE DOCUMENTO DE VENTA ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_tipo_doc_compra
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_tipo_doc <> varCodigo;
    if varExiste <= 0 then 
      update _sv_tipo_doc_compra 
      set
      nombre       = UPPER(varNombre), 
      abrev        = varAbrev, 
      cod_sunat    = varSunat,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_tipo_doc = varCodigo;
    else
      set varError = CONCAT('EL TIPO DE DOCUMENTO DE VENTA ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;