call spMante_Reservacion('NEW', NULL, 1, 2, 3, '2012-08-23', '2012-08-24', 12, 0, 'AC', 1);

DROP PROCEDURE IF EXISTS spMante_Reservacion;
CREATE PROCEDURE spMante_Reservacion(
	varOpcion     varchar(10),
	varCodigo     varchar(15),	
	varEmpresa    int,
  varTrabajador int,
  varCliente    int,
  varIngreso    date,
  varSalida     date,
  varQAdultos   int,
  varQNinos     int,
  varEstado     varchar(2),
	varUsuario    int
)
BEGIN  
  DECLARE varExiste int default 0;

	if varOpcion='NEW' then
    -- Generamos Siguiente Correlativo
    SELECT ifnull(max(id_reservacion),0)+1 INTO varCodigo FROM _sh_reservacion;    
    -- Insertamos Registro
    INSERT INTO _sh_reservacion (id_reservacion, id_empresa, id_trabajador, id_cliente, fecha_ingreso, fecha_salida, 
                                 cant_adultos, cant_ninos, estado, _date_create, _date_update, _user_create, _user_update) 
    values (varCodigo, varEmpresa, varTrabajador, varCliente, varIngreso, varSalida,
            varQAdultos, varQNinos, varEstado, NOW(),NOW(), varUsuario, varUsuario);
  
	else
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    update _sh_reservacion set		
    id_cliente    = varCliente,
    fecha_ingreso = varIngreso,
    fecha_salida  = varSalida,
    cant_adultos  = varQAdultos,
    cant_ninos    = varQNinos,
    estado        = varEstado,
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_reservacion = varCodigo;
  end if;
  select varCodigo;
END;