DROP PROCEDURE IF EXISTS spMante_Producto_Tipo;
CREATE PROCEDURE spMante_Producto_Tipo(
	varOpcion   varchar(10),
	varCodigo   varchar(2),
	varNombre   varchar(80),
  varTipo     char(1),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_tipo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT LPAD(ifnull(max(id_tipo),0)+1,2,'0') INTO varCodigo FROM _sv_tipo WHERE id_tipo not in ('00','99');
      INSERT INTO _sv_tipo (id_tipo, nombre, flag_proser, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varTipo, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA LINEA ', varNombre, ' YA SE ENCUENTRA REGISTRADA');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_tipo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and TRIM(id_tipo) <> TRIM(varCodigo);
    if varExiste <= 0 then 
      update _sv_tipo set
      nombre        = UPPER(varNombre), 
      flag_proser   = varTipo,
      _date_update  = NOW(),
      _user_update  = varUsuario
      where id_tipo = varCodigo;
    else
      set varError = CONCAT('LA LINEA ', varNombre, ' YA SE ENCUENTRA REGISTRADO AAS');
    end if;
	end if;
  select varError;
END;