DROP PROCEDURE IF EXISTS spMante_Producto_Material;
CREATE PROCEDURE spMante_Producto_Material(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_material
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_material),0)+1 INTO varCodigo FROM _sv_material;
      INSERT INTO _sv_material (id_material, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL MATERIAL ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_material
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_material <> varCodigo;
    if varExiste <= 0 then 
      update _sv_material set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_material = varCodigo;
    else
      set varError = CONCAT('EL MATERIAL ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;