call spMante_Pedido_Anular(5, 1);

DROP PROCEDURE IF EXISTS spMante_Pedido_Anular;
CREATE PROCEDURE spMante_Pedido_Anular(  
	varNumPed   bigint,
  varUsuario  int
  )
BEGIN 
  Declare varVerifExiste, varLocal, varVerifStock int;
  Declare varCantidad   double;  
  Declare varProducto   varchar(6);
  
/*==============================================================
  VERIFICAMOS SI EL PEDIDO YA ESTA ANULADO
  ==============================================================*/
  select count(id_pedido) into varVerifExiste 
  from _sv_pedido
  where id_pedido= varNumPed 
  and estado <> 'AN';
  
  if varVerifExiste > 0 then
    UPDATE _sv_pedido
    SET estado   = 'AN',
    _user_update = varUsuario,
    _date_update = NOW()
    where id_pedido = varNumPed;
    
    SELECT 'OK' AS RESUL;    
  else
    SELECT 'EL PEDIDO YA ESTA ANULADO' AS RESUL;
  end if;
END;