Call spMante_ocupacion('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Ocupacion;
CREATE PROCEDURE spMante_Ocupacion(
	varOpcion   varchar(10),
	varCodigo   varchar(6),
	varNombre   varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_ocupacion 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('LA OCUPACION <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_ocupacion),0)+1 INTO varCodigo FROM _srh_ocupacion;
      INSERT INTO _srh_ocupacion (id_ocupacion, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_ocupacion 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_ocupacion <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('LA OCUPACION <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_ocupacion set
      nombre       = UPPER(varNombre),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_ocupacion = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;