DROP PROCEDURE IF EXISTS spMante_Marca_Vehiculo;
CREATE PROCEDURE spMante_Marca_Vehiculo(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_marca_vehiculo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A';
    if varExiste <= 0 then 
      SELECT ifnull(max(id_marca),0)+1 INTO varCodigo FROM _sv_marca_vehiculo;
      INSERT INTO _sv_marca_vehiculo (id_marca, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA MARCA ', varNombre, ' YA SE ENCUENTRA REGISTRADA');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_marca_vehiculo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_marca <> varCodigo;
    if varExiste <= 0 then 
      update _sv_marca_vehiculo set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_marca = varCodigo;
    else
      set varError = CONCAT('LA MARCA ', varNombre, ' YA SE ENCUENTRA REGISTRADA');
    end if;
	end if;
  select varError;
END;