call spMante_Lista_Precios_Detalle('EDIT', 1, 1, '010002', 
												  'UND', 1.9, 1);

DROP PROCEDURE IF EXISTS spMante_Lista_Precios_Detalle;
CREATE PROCEDURE spMante_Lista_Precios_Detalle(
  varOpcion   varchar(10),
  varEmpresa  int,
  varLista    int,
	varProducto varchar(6),
	varUM       varchar(10),
  varPrecio   double,
	varUsuario  int
)
BEGIN  
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  if varOpcion='NEW' then    
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    select count(*) INTO varExiste from _sv_lista_producto 
    where id_lista  = varLista 
    and id_producto = varProducto
    and id_empresa  = varEmpresa
    and _estado = 'A';
    
    if varExiste <= 0 then 
      INSERT INTO _sv_lista_producto (id_empresa, id_lista, id_producto, id_um, precio, _date_create, _date_update, _user_create, _user_update) 
      values (varEmpresa, varLista, varProducto, varUM, varPrecio, NOW(),NOW(), varUsuario, varUsuario);
    else
        set varError = CONCAT('Empresa\t\t: ', varEmpresa, ' - ', (select nombre from _sv_empresa where id_empresa = varEmpresa), '\n',
                              'Lista Precios\t: ', varLista, ' - ', (select nombre from _sv_lista where id_lista = varLista and id_empresa = varEmpresa), '\n',
                              'Producto\t\t: ', varProducto, ' - ', (select descripcion from _sv_producto where id_producto = varProducto), '\n',
                              'YA SE ENCUENTRA REGISTRADO EN EL SISTEMA');
    end if; 
  else
    UPDATE _sv_lista_producto
    SET id_um    = varUM, 
    precio       = varPrecio,
    _date_update = NOW(),
    _user_update = varUsuario
    WHERE id_empresa = varEmpresa
    and id_lista     = varLista
    and id_producto  = varProducto;
  end if;
  select varError; 
END;