call spMante_Hospedaje('NEW', NULL, 1, 2, 1, 1, '2012-09-12 19:40:00', '2012-09-12 21:40:00', 2, 0, 'AC', 1);

DROP PROCEDURE IF EXISTS spMante_Hospedaje;
CREATE PROCEDURE spMante_Hospedaje(
	varOpcion     varchar(10),
	varCodigo     varchar(15),
	varEmpresa    int,
  varTrabajador int,
  varCliente    int,
  varSegmento   int,
  varIngreso    datetime,
  varSalida     datetime,
  varQAdultos   int,
  varQNinos     int,
  varEstado     varchar(2),
	varUsuario    int
)
BEGIN  
  DECLARE varExiste int default 0;

	if varOpcion='NEW' then
    -- Generamos Siguiente Correlativo
    SELECT ifnull(max(id_hospedaje),0)+1 INTO varCodigo FROM _sh_hospedaje;    
    -- Insertamos Registro
    INSERT INTO _sh_hospedaje (id_hospedaje, id_empresa, id_trabajador, id_cliente, id_segmento, fecha_ingreso, fecha_salida, 
                                 cant_adultos, cant_ninos, estado, _date_create, _date_update, _user_create, _user_update) 
    values (varCodigo, varEmpresa, varTrabajador, varCliente, varSegmento, varIngreso, varSalida,
            varQAdultos, varQNinos, varEstado, NOW(),NOW(), varUsuario, varUsuario);
  
	else
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    update _sh_hospedaje set		
    id_cliente    = varCliente,
    id_segmento   = varSegmento,
    fecha_salida  = varSalida,
    cant_adultos  = varQAdultos,
    cant_ninos    = varQNinos,
    estado        = varEstado,
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_hospedaje = varCodigo;
  end if;
  select varCodigo;
END;