call spMante_Empresa('EDIT', 2, 'ALMACENES DE LA SELVA S.A.C.', '20531321970', 'ALSE', 'JR. LIMA NRO. 1420 SAN MARTIN - SAN MARTIN - TARAPOTO', 1)

DROP PROCEDURE IF EXISTS spMante_Empresa;
CREATE PROCEDURE spMante_Empresa(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varRuc      varchar(11),
  varAbrev    varchar(20),
  varDirecc   varchar(100),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Validamos que el razon social de la empresa no exista
    select count(*) INTO varExiste  from _sv_empresa where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    if varExiste > 0 then
      set varError = CONCAT('LA EMPRESA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA\n');
    end if;
    
    -- Validamos que el RUC de la empresa no exista
    select count(*) INTO varExiste from _sv_empresa where TRIM(ruc) = TRIM(varRuc)  and _estado = 'A';
    if varExiste > 0 then
      set varError = CONCAT(varError, 'EL NRO. DE RUC <<', UPPER(varRuc), '>> YA SE ENCUENTRA REGISTRADO\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_empresa),0)+1 INTO varCodigo FROM _sv_empresa;
      INSERT INTO _sv_empresa (id_empresa, nombre, abrev, ruc, direccion, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), UPPER(varAbrev), varRuc, UPPER(varDirecc), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Validamos que el razon social de la empresa no exista
    select count(*) INTO varExiste  from _sv_empresa where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' and id_empresa <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('LA EMPRESA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA\n');
    end if;
    -- Validamos que el RUC de la empresa no exista
    select count(*) INTO varExiste  from _sv_empresa where TRIM(ruc) = TRIM(varRuc)  and _estado = 'A' and id_empresa <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT(varError, 'EL NRO. DE RUC <<', UPPER(varRuc), '>> YA SE ENCUENTRA REGISTRADO\n');
    end if;
    
    if varError = '' then 
      update _sv_empresa set
      nombre    = UPPER(varNombre), 
      abrev     = UPPER(varAbrev),
      ruc       = varRuc,
      direccion = varDirecc,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_empresa = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;