call spMante_Cuota_Compra_Proveedor('NEW', '2012', '11',1, 1, 0, 200, 1);

DROP PROCEDURE IF EXISTS spMante_Cuota_Compra_Proveedor;
CREATE PROCEDURE spMante_Cuota_Compra_Proveedor(
  varOpcion     varchar(10),
  varAnio       varchar(4),
  varMes        varchar(2),
  varEmpresa    int,
  varProveedor  int,  
  varMonto      double,
  varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  DECLARE varDEmp, varDPro, varDMes varchar(80) default '';
  
  select nombre into varDEmp from _sv_empresa where id_empresa = varEmpresa;
  select nombre into varDPro from _sv_proveedor where id_proveedor = varProveedor;
  select spFuncion_NombreMes(varMes) into varDMes;
  
  if varOpcion='NEW' then
    select count(*) INTO varExiste from _sv_cuota_compra_proveedor
    where id_anio    = varAnio
    and id_mes       = varMes
    and id_empresa  = varEmpresa
    and id_proveedor = varProveedor
    and _estado = 'A';
    
    if varExiste <= 0 then 
      INSERT INTO _sv_cuota_compra_proveedor (id_anio, id_mes, id_empresa, id_proveedor, monto, 
                  _date_create, _date_update, _user_create, _user_update) 
      values (varAnio, varMes, varEmpresa, varProveedor, varMonto, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA CUOTA PARA\n',
                            'Anio \t\t: ', varAnio, '\n',
                            'Mes \t\t: ', varMes, ' - ', UPPER(varDMes), '\n',
                            'Empresa \t: ', varEmpresa, ' - ', UPPER(varDEmp), '\n',
                            'Proveedor \t: ', varProveedor, ' - ', UPPER(varDPro));
    end if;
  else
    update _sv_cuota_compra_proveedor set
    monto = varMonto,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_anio     = varAnio
    and id_mes        = varMes
    and id_empresa    = varEmpresa
    and id_proveedor  = varProveedor;
  end if;
  select varError;
END;
