call spMante_Concepto_Remunerativo('EDIT', '2001', 'RPC', '20', '0706', '0706', 1);
call spMante_Concepto_Remunerativo('NEW', NULL, 'OTRO DESCUENTO', '20', NULL, NULL, 1);

DROP PROCEDURE IF EXISTS spMante_Concepto_Remunerativo;
CREATE PROCEDURE spMante_Concepto_Remunerativo(
	varOpcion   varchar(10),
	varCodigo   varchar(5),
	varNombre   varchar(100),
  varAbrev    varchar(10),
  varTipo     varchar(2),
  varAgPdt    varchar(5),
  varAgBoleta varchar(5),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
  DECLARE varCodTemp varchar(6);
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_concepto_remunerativo
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) 
    and id_tipo_concepto      = varTipo
    and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL CONCEPTO REMUNERATIVO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT CONCAT(varTipo,CAST(LPAD(ifnull(max(substring(id_concepto,3,2)),0)+1,2,'0') AS CHAR))
      INTO varCodigo 
      FROM _srh_concepto_remunerativo
      where id_tipo_concepto = varTipo;
    
      INSERT INTO _srh_concepto_remunerativo (id_concepto, id_tipo_concepto, nombre, abrev, agrupa_pdt, agrupa_boleta,
              _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varTipo, UPPER(varNombre), UPPER(varAbrev), varAgPdt, varAgBoleta, 
              NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_concepto_remunerativo 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) 
    and id_tipo_concepto      = varTipo
    and _estado = 'A' 
    and id_concepto <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL CONCEPTO REMUNERATIVO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_concepto_remunerativo set
      id_tipo_concepto      = varTipo,      
      nombre                = UPPER(varNombre), 
      abrev                 = UPPER(varAbrev),
      agrupa_pdt            = varAgPdt,
      agrupa_boleta         = varAgBoleta,
      _date_update          = NOW(),
      _user_update          = varUsuario
      where id_concepto     = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;