Call spMante_Area('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Area;
CREATE PROCEDURE spMante_Area(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varAbrev    varchar(50),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_area 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL AREA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_area),0)+1 INTO varCodigo FROM _srh_area;
      INSERT INTO _srh_area (id_area, nombre, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), UPPER(varAbrev), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_area 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_area <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL AREA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_area set
      nombre       = UPPER(varNombre),
      abrev        = UPPER(varAbrev),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_area = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;