select spFuncion_DiasAcumulados('2013','01');
DROP FUNCTION IF EXISTS spFuncion_DiasAcumulados;
CREATE FUNCTION spFuncion_DiasAcumulados(
	varAnio varchar(4), 
	varMes  varchar(2)
	) RETURNS int(11)
BEGIN 
  DECLARE varDiaAcum int;
  DECLARE varFechaIni, varFechaFin date;  
  
  set varFechaIni = STR_TO_DATE(concat('01','.',lpad(varMes,2,'0'),'.',varAnio),'%d.%m.%Y');
  set varFechaFin = LAST_DAY(STR_TO_DATE(concat('01','.',varMes,'.',varAnio),'%d.%m.%Y')); 
  
  select count(distinct fecha_emision) into varDiaAcum
  from _sv_venta
  where fecha_emision >= varFechaIni
  and fecha_emision <= varFechaFin
  and DATE_FORMAT(fecha_emision, '%a') <> 'Sun' ;  
	return varDiaAcum;
end;

select distinct fecha_emision, date_format(fecha_emision,'%w')
from _sv_venta
where fecha_emision>='2011-08-01'
and fecha_emision <= '2011-08-31'