SELECT spFuncion_DetalleDocumento(1);

DROP FUNCTION IF EXISTS spFuncion_DetalleDocumento;
CREATE FUNCTION spFuncion_DetalleDocumento(
	varVenta  int
	) RETURNS TEXT CHARSET latin1
BEGIN 
  DECLARE varReturn     text  DEFAULT '<table width="100%" >';
  DECLARE varCurCodigo  varchar(10);
  DECLARE varCurNombre  varchar(80);
  DECLARE varCurCant, varCurTotal  double;
  
  DECLARE done INT DEFAULT 0;
  DECLARE curMov CURSOR FOR 
      select D.id_producto, P.descripcion, D.cantidad, D.total
      from _sv_venta_detalle D
      inner join _sv_producto P ON D.id_producto = P.id_producto
      where id_venta  = varVenta;
  
	DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  OPEN curMov;
    REPEAT
      FETCH curMov INTO   varCurCodigo, varCurNombre, varCurCant, varCurTotal;
      IF NOT done THEN  
          
          set varReturn = CONCAT(varReturn,'<tr class="list_row2">','<td width="40">',varCurCodigo,'</td><td width="280">', varCurNombre, '</td><td align="right">', ROUND(varCurCant,2), '</td><td align="right">',ROUND(varCurTotal,2),'</td></tr>');
          
      END IF;
    UNTIL done END REPEAT;
  CLOSE curMov;
  
  set varReturn = CONCAT(varReturn,'</table>');
  
  return varReturn;
  
end;
