call spQuery_Registro_Ventas_Contenido(2);

DROP PROCEDURE IF EXISTS spQuery_Registro_Ventas_Contenido;
CREATE PROCEDURE spQuery_Registro_Ventas_Contenido(  
	varVenta    int
  )
BEGIN
  select D.id_producto AS CPRO, 
  CONCAT(CAST(CASE WHEN D.id_tipo='B' THEN '(B) ' ELSE '' END AS CHAR), CAST(A.descripcion AS CHAR)) AS PRODUCTO, 
  D.id_tipo as TIPO,
  D.id_um as UM,
  D.PRECIO,
  D.CANTIDAD,
  D.TOTAL,
  D.LOTE,
  DATE_FORMAT(D.fecha_vencimiento,'%d/%m/%Y') AS FVENC
  from _sv_venta_detalle D
  inner join _sv_producto A ON D.id_producto = A.id_producto
  where D.id_venta  = varVenta
  and D._estado = 'A';
END;