CALL spQuery_Registro_Guias_Detalle(4);

DROP PROCEDURE IF EXISTS spQuery_Registro_Guias_Detalle;
CREATE PROCEDURE spQuery_Registro_Guias_Detalle(  
	varGuia    int
  )
BEGIN 
  select date_format(C.fecha_emision,'%d/%m/%Y') AS EMISION,
  date_format(C.fecha_traslado,'%d/%m/%Y') AS TRASLADO,
  C.id_tipo_doc as CTIPD,
	T.nombre AS CTIP, C.nro_documento AS NDOC,
	C.id_cliente as CCLI, P.nombre as CLIENTE, 
  P.RUC, P.DNI,
	C.id_vendedor as CVEN, V.nombre as VENDEDOR, 
	C.id_condicion as CCON, TC.nombre as CONDICION, 		
	C.TOTAL, C.ESTADO, 	
  C.id_ubigeo_partida AS UBI_PAR, UP.departamento AS DEP_PAR, UP.provincia AS PRO_PAR, UP.distrito AS DIS_PAR,
  C.direccion_partida as DIRE_PAR,
  C.id_ubigeo_destino AS UBI_DES, UD.departamento AS DEP_DES, UD.provincia AS PRO_DES, UD.distrito AS DIS_DES,
  C.direccion_destino as DIRE_DES,
  TV.nombre as TIPO_REF, Ve.nro_documento as DOC_REF,
  date_format(C._date_create,'%d/%m/%Y %h:%m:%s %p') as SISTEMA
	from _sv_guia C  
  inner join _sv_ubigeo UP  ON C.id_ubigeo_partida = UP.id_ubigeo
	inner join _sv_Cliente P  ON C.id_cliente = P.id_cliente
  inner join _sv_ubigeo UD  ON C.id_ubigeo_destino = UD.id_ubigeo
	inner join _sv_vendedor V ON C.id_vendedor = V.id_vendedor
	inner join _sv_forma_pago T ON C.id_tipo_doc = T.id_tipo_doc
	inner join _sv_tipo_condicion TC ON C.id_condicion = TC.id_condicion
  inner join _sv_venta Ve   ON C.id_venta = Ve.id_venta
  inner join _sv_forma_pago TV ON Ve.id_tipo_doc = TV.id_tipo_doc
	where C._estado='A'
	AND C.id_guia=varGuia;
END;