call spQuery_Registro_Compras_Update(NULL, '2012-04-01', NULL);

DROP PROCEDURE IF EXISTS spQuery_Registro_compras_Update;
CREATE PROCEDURE spQuery_Registro_compras_Update(  
	varProveedor  int,  
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadProveedor varchar(100) DEFAULT '';
  
  IF IFNULL(varProveedor,0) <> 0 THEN
    SET varCadProveedor = CONCAT(" and C.id_proveedor = ", varProveedor, " ");  
  END IF;
    
  IF varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and C.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and C.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  set @sql = CONCAT("select C.id_compra as IDE, date_format(C.fecha_emision,'%d/%m/%Y') AS FECHA, ",
                    "C.id_tipo_doc as CTIP, T.nombre as TIPO_DOC, ",
                    "C.nro_documento as DOCUMENTO, ",
                    "C.ESTADO, ",                                        
                    "C.id_proveedor as CPRO, P.nombre as PROVEEDOR, ",
                    "C.SUBTOTAL, C.IGV, C.TOTAL, ", 
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_compra C ",
                    "inner join _sv_proveedor P ON C.id_proveedor = P.id_proveedor ",
                    "inner join _sv_tipo_doc_venta T ON C.id_tipo_doc = T.id_tipo_doc ",
                    "inner join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
                    "and C.estado <> 'AN' ",
                    varCadproveedor, varCadFechaIni, varCadFechaFin,
                    "order by C.id_compra");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;
