call spQuery_Modulo(NULL,'','FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Modulo;
CREATE PROCEDURE spQuery_Modulo(
  varCodigo varchar(60),
	varNombre varchar(60),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_modulo LIKE '%", varCodigo, "%' ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_modulo AS CMOD, M.nombre AS MODULO, ",
                    "(select count(id_cliente) as CANT from _sv_cliente C where C._estado='A' and C.id_modulo = M.id_modulo) as NUM_CLI, ",
                    "M.id_ruta as CRUT, F.nombre as RUTA, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_modulo M ",
                    "inner join _sv_ruta F ON M.id_ruta = F.id_ruta ",
                    "inner join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' and M.id_modulo <> 0 ",
	                  varCadCod, varCadNom,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;