call spQuery_Factor_Conversion('UND');

DROP PROCEDURE IF EXISTS spQuery_Factor_Conversion;
CREATE PROCEDURE spQuery_Factor_Conversion(
	varUM       varchar(10)
)
BEGIN
  select id_um_origen as UORI, O.nombre as UM_ORIGEN, 
  OPERACION, FACTOR,
  id_um_destino as UDES, D.nombre as UM_DESTINO,
  DATE_FORMAT(F._date_create,'%d/%m/%Y %h:%m:%s %p') as FCREATE,
  DATE_FORMAT(F._date_create,'%d/%m/%Y %h:%m:%s %p') as FUPDATE,
  UPPER(UC.usuario) as UCREATE,
  UPPER(UU.usuario) as UUPDATE
  from _sv_factor_conv F
  inner join _sv_unid_medida O ON F.id_um_origen  = O.id_um
  inner join _sv_unid_medida D ON F.id_um_destino = D.id_um
  left join _sys_usuario UC   ON F._user_create = UC.id_usuario
  left join _sys_usuario UU   ON F._user_update = UU.id_usuario
  where id_um_origen = varUM
  and F._estado = 'A';
END;