CALL spQuery_Avance_Vendedor_Proveedor(15,'','2011-07-01','');

DROP PROCEDURE IF EXISTS spQuery_Avance_Vendedor_Proveedor;
CREATE PROCEDURE spQuery_Avance_Vendedor_Proveedor(  
	varVendedor   int,
  varProveedor  int,  
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadProveedor, varCadVendedor varchar(100) DEFAULT '';
  
  IF IFNULL(varProveedor,0) <> 0 and varProveedor <> '' THEN
    SET varCadProveedor = CONCAT(" and P.id_proveedor = ", varProveedor, " ");  
  END IF;
  
  IF IFNULL(varVendedor,0) <> 0 and varVendedor <> '' THEN
    SET varCadVendedor = CONCAT(" and C.id_vendedor = ", varVendedor, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni IS NOT NULL and varFechaIni <> '0000-00-00' THEN
    SET varCadFechaIni = CONCAT(" and C.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin IS NOT NULL and varFechaFin <> '0000-00-00' THEN
    SET varCadFechaFin = CONCAT(" and C.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  set @sql = CONCAT("SELECT C.id_vendedor as CVEN, V.nombre as VENDEDOR, ",
                    "P.id_proveedor as CPRO, Pr.nombre as PROVEEDOR, ",
                    "sum(D.subtotal) as SUBTOTAL, ",
                    "sum(D.igv) as IGV, ",
                    "sum(D.total) as TOTAL ",
                    "FROM _sv_venta_detalle D ",
                    "inner join _sv_venta C    ON D.id_venta = C.id_venta ",
                    "inner join _sv_vendedor V ON C.id_vendedor = V.id_vendedor ",
                    "inner join _sv_producto P ON D.id_producto = P.id_producto ",
                    "inner join _sv_proveedor Pr ON P.id_proveedor = Pr.id_proveedor "
                    "where C._estado = 'A' ",
                    "and D._estado = 'A' ",
                    "and C.estado <> 'AN' ",
                    varCadProveedor, varCadVendedor, varCadFechaIni, varCadFechaFin,
                    "group by C.id_vendedor, V.nombre, ",
                    "P.id_proveedor, PR.nombre ");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;  
END;