CALL spProceso_Genera_Nueva_Venta(31763, 'FAC', 1);

DROP PROCEDURE IF EXISTS spProceso_Genera_Nueva_Venta;
CREATE PROCEDURE spProceso_Genera_Nueva_Venta(
	varVenta    int, 
  varTipo     varchar(3),  
  varUsuario  int
  )
BEGIN
  DECLARE varExiste int;
  DECLARE varNumDoc varchar(20);
  DECLARE varNomDoc varchar(20);
  DECLARE varDoc, varCli, varFec varchar(100);
  
  -- Obtenemos datos del documento a cambiar
  select CONCAT(T.nombre, ' ', V.nro_documento) as Doc, 
  CONCAT(cast(V.id_cliente as char), ' - ', C.nombre) as Cli, 
  cast(date_format(fecha_emision, '%d/%m/%Y') as char) as Fec
  into varDoc, varCli, varFec
  from _sv_venta V
  inner join _sv_cliente C on V.id_cliente = C.id_cliente
  inner join _sv_tipo_doc_venta T on V.id_tipo_doc = T.id_tipo_doc
  where id_venta = varVenta;
  
  if varTipo = 'BOL' then
    set varTipo = 3;
    set varNomDoc = 'BOLETA';
  elseif varTipo = 'FAC' then
    set varTipo = 2;
    set varNomDoc = 'FACTURA';
  end if;
  
  select count(*) INTO varExiste 
  from _sv_venta 
  where id_venta  = varVenta 
  and id_tipo_doc = 1
  and estado     <> 'AN'
  and _estado     = 'A';
  
  if varExiste > 0 then
    set varNumDoc = spFuncion_NumeroDocumento(varTipo);
    
    -- GENERAMOS EL NUEVO DOCUMENTO
    update _sv_venta 
    set id_tipo_doc = varTipo,
    nro_documento   = varNumDoc,
    _user_update    = varUsuario,
    _date_update    = NOW()
    where id_venta  = varVenta;
    
    -- ACTUALIZAMOS EL CORRELATIVO
    update _sv_tipo_doc_venta
    set secuencia=secuencia+1
    where id_tipo_doc = varTipo;
    SELECT 'OK' as Cond, CONCAT("SE CONVIRTIO EL DOCUMENTO",
                                "\nFecha Emisin\t: ",varFec,
                                "\nDocumento\t: ", varDoc,
                                "\nCliente\t\t: ", varCli,
                                "\nA UNA NUEVA ", varNomDoc,
                                " CON NUMERO ", varNumDoc) as Mensaje;
  else
    SELECT 'ERROR' as Cond, CONCAT("NO SE PUEDE CONVERTIR EL DOCUMENTO",
                                  "\nFecha Emisin\t: ",varFec,
                                  "\nDocumento\t: ", varDoc,
                                  "\nCliente\t: ", varCli) as Mensaje;
  end if;
END;
