call spMante_Venta_Det(88103, 2, 3, '020011', '201', 24, 0.82, 'UND', 'V', '2014-01-03', 1);

DROP PROCEDURE IF EXISTS spMante_Venta_Det;
CREATE PROCEDURE spMante_Venta_Det(  
	varNumVenta   int, 
  varEmpresa    int,
  varAlmacen    int,
	varProducto   varchar(6),
  varMovimiento varchar(5),
	varCantidad   double,
  varUnitario   double,
  varUnidMed    varchar(10),
  varTipoDet    char(1),
  varFecha      date,  
  varUsuario    int
  )
BEGIN  
  DECLARE varTotal, varSubTotal, varIgv, varFactor, varCantStock double;  
  DECLARE varUMStock, varOpera varchar(10);
  DECLARE varCantReal  double;
  
  SET varUMStock    = (select id_um_stock from _sv_producto where id_producto = varProducto);
  
  SET varCantReal  = (select  case when F.operacion = '*' then (case when K.cantidad>0 then K.cantidad else 0 end)*F.factor 
                                   when F.operacion = '/' then (case when K.cantidad>0 then K.cantidad else 0 end)/F.factor 
                              end as STOCK
                      from _sv_kardex K
                      inner join _sv_producto P ON K.id_producto = P.id_producto
                      inner join _sv_factor_conv F ON P.id_um_stock = F.id_um_origen and P.id_um_venta = F.id_um_destino
                      where K._estado   = 'A'
                      and K.id_almacen  = varAlmacen
                      and K.id_producto = varProducto
                      );
  
  select factor, operacion 
  into varFactor, varOpera
  from _sv_factor_conv
  where id_um_origen  = varUnidMed 
  and id_um_destino   = varUMStock;
  
/*=================================================================== 
  Si no hay stock suficiente en el almacen
  entonces vendemos todos los productos que quedan en nuestro almacen
  ===================================================================*/
  if varCantReal < varCantidad then
    set varCantidad = varCantReal;
  end if;
  
  -- Calculamos los Montos por Producto
  SET varTotal      = round(varCantidad*varUnitario,2);
  SET varIgv        = round(varTotal - varTotal/1.18,2);
  SET varSubTotal   = round(varTotal/1.18,2);
    
  SET varCantStock  = CASE WHEN varOpera = '*' THEN varCantidad*varFactor
                           WHEN varOpera = '/' THEN varCantidad/varFactor
                      END;
  
  /*Si no hay nada de stock en el almacen no registramos el item*/
  if varCantReal > 0 then
      /* Registramos Detalle del Documento */
      insert into _sv_venta_detalle(id_venta, id_producto, id_um, id_tipo, id_movimiento,
                                    cantidad, cantidad_ate, precio, subtotal, igv, total, 
                                    _date_create, _date_update, _user_create, _user_update) 
      values (varNumVenta, varProducto, varUnidMed, varTipoDet, varMovimiento, 
              varCantidad, varCantidad, varUnitario, varSubTotal, varIgv, varTotal, 
              NOW(), NOW(), varUsuario, varUsuario);
      
      
      /* Actualizamos el KARDEX */
      update _sv_kardex 
      SET cantidad = cantidad - varCantStock,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_empresa  = varEmpresa 
      and id_almacen    = varAlmacen
      and id_producto   = varProducto;
      
      /*Registramos el movimiento Realizado */
      insert into _sv_movimiento_almacen(id_movimiento, id_empresa, id_almacen, id_referencia, id_producto, cantidad, fecha, _date_create, _date_update, _user_create, _user_update)
      values(varMovimiento, varEmpresa, varAlmacen, varNumVenta, varProducto, varCantStock, varFecha, NOW(), NOW(), varUsuario, varUsuario); 
  end if;
END;