call spMante_Venta_Cab(2, 2, 3, 3, 3, 6, 1, '2013-12-20', 142, '1V5442', 4, 41768484, NULL, NULL, 23.63, 1);

DROP PROCEDURE IF EXISTS spMante_Venta_Cab;
CREATE PROCEDURE spMante_Venta_Cab(
  varEmpresa    int,
  varAgencia    int,
  varAlmacen    int,
  varPuntoVenta int,
	varTipoDoc    int,
  varSerie      int,
	varCondicion  int,
  varFecha      date, 
  varCliente    int,
  varRuta       varchar(10),
  varLista      int,
  varVendedor   int,
  varPedido     varchar(20),
  varGlosa      text,
	varTotal      double,
  varUsuario    int
  )
BEGIN  
	DECLARE varNumVenta, varNumPago, varExiste int;
  DECLARE varTipoNom, varNumSer, varNumSec, varCond varchar(20);
  DECLARE varSubTotal, varIgv double;
  DECLARE varFVen     date;
  DECLARE varError text default 'OK';
  DECLARE varVerif text default '';
  
  -- VERIFICAMOS QUE LOS DATOS INGRESADOS SEAN CORRECTOS
  SET varVerif = spFuncion_Existe_Registro('_sv_empresa', varEmpresa);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_srh_agencia', varAgencia);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_almacen', varAlmacen);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_punto_venta', varPuntoVenta);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_punto_venta', varPuntoVenta);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_tipo_doc_venta', varTipoDoc);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_tipo_condicion', varCondicion);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_cliente', varCliente);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_ruta', varRuta);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  SET varVerif = spFuncion_Existe_Registro('_sv_vendedor', varVendedor);
  IF varVerif <> 'OK' THEN
    IF varError = 'OK' THEN
      SET varError = CONCAT("=> ",varVerif,"\n");
    ELSE
      SET varError = CONCAT(varError, "=> ",varVerif,"\n");
    END IF;
  END IF;
  /*Verificamos si existe almacen de averias*/
  select count(id_almacen) into varExiste 
  from _sv_almacen
  where id_almacen = varAlmacen
  and id_averias is null;
  if varExiste > 0 then
    IF varError = 'OK' THEN
      SET varError = "=> NO EXISTE ALMACEN DE AVERIAS\n";
    ELSE
      SET varError = CONCAT(varError, "=> NO EXISTE ALMACEN DE AVERIAS CONFIGURADO\n");
    END IF;
  end if;
  
  IF varError = 'OK' THEN
    IF date_format(varFecha,'%d/%m/%Y') <> '00/00/0000' and  varFecha is not null THEN
      SELECT if(isnull(MAX(id_venta)),0,MAX(id_venta))+1 INTO varNumVenta FROM _sv_venta;
      
      SELECT tipo, DATE_ADD(NOW(), INTERVAL dias DAY) 
      INTO varCond, varFVen
      FROM _sv_tipo_condicion WHERE id_condicion = varCondicion;
      
      select T.nombre, S.nro_serie, cast(lpad(S.nro_secuencia+1,7,'0') as char) as secuencia
      into varTipoNom, varNumSer, varNumSec
      from _sv_serie_punto_venta S
      inner join _sv_tipo_doc_venta T ON S.id_tipo_doc = T.id_tipo_doc
      where S.id_serie = varSerie;
      
      
      SET varSubTotal = round(varTotal/1.18,2);
      SET varIgv      = round(varTotal - varTotal/1.18,2);
      
      /*Actualizamos Ultima Compra del Cliente*/
      update _sv_cliente set ultima_compra=varFecha where id_cliente=varCliente;
      
      /*Registramos Cabecera de la Venta*/	
      insert into _sv_venta (id_venta, id_empresa, id_agencia, id_almacen, id_punto_venta, id_cliente, id_trabajador, id_lista, 
                            id_ruta, fecha_emision, fecha_vencimiento, id_condicion, id_tipo_doc, nro_serie, nro_preimpreso, 
                            nro_pedido, glosa, estado, subtotal, igv, total, saldo, 
                            _date_create, _date_update, _user_create, _user_update)
      VALUES (varNumVenta, varEmpresa, varAgencia, varAlmacen, varPuntoVenta, varCliente, varVendedor, varLista, varRuta, 
              varFecha, varFVen, varCondicion, varTipoDoc, varNumSer, varNumSec,  
              varPedido, UPPER(varGlosa), 'AC', varSubTotal, varIgv, varTotal, varTotal, 
              NOW(), NOW(), varUsuario, varUsuario);                     
      
      /*REGISTRAMOS LA VENTA EN MOVIMIENTO CUENTA */
      insert into _sv_movimiento_cuenta_cxc(id_empresa, id_agencia, id_punto_venta, id_cliente, id_venta, id_pago_cxc, tipo_mov, 
                            fecha, monto, _date_create, _date_update, _user_create, _user_update)
      values (varEmpresa, varAgencia, varPuntoVenta, varCliente, varNumVenta, NULL, 'VEN', varFecha, varTotal, 
                            NOW(), NOW(), varUsuario, varUsuario);
      
     
      /*SI ES CONTADO REGISTRAMOS EL PAGO EN EL MOVIMIENTO CUENTA*/  
      if varCond='CO' then  
        SELECT if(isnull(MAX(id_pago_cxc)),0,MAX(id_pago_cxc))+1 INTO varNumPago FROM _sv_pago_cxc; 
        
        insert into _sv_pago_cxc(id_pago_cxc, id_empresa, id_agencia, id_punto_venta, id_cliente, id_venta, id_forma_pago,
                              nro_doc_pago, fecha, monto, observacion, _date_create, _date_update, _user_create, _user_update)
        values(varNumPago, varEmpresa, varAgencia, varPuntoVenta, varCliente, varNumVenta, 1, '00001', varFecha, varTotal, 
                              'Pago al Contado', NOW(), NOW(), varUsuario, varUsuario);
    
        insert into _sv_movimiento_cuenta_cxc(id_empresa, id_agencia, id_punto_venta, id_cliente, id_venta, id_pago_cxc, 
                              tipo_mov, fecha, monto, _date_create, _date_update, _user_create, _user_update)
        values(varEmpresa, varAgencia, varPuntoVenta, varCliente, varNumVenta, varNumPago, 'PAG', varFecha, varTotal, 
                              NOW(), NOW(), varUsuario, varUsuario);     
       
        update _sv_venta set estado='CA', saldo=0 where id_venta = varNumVenta;
      end if;
      
      /*ACTUALIZAMOS EL CORRELATIVO DEL TIPO DE DOCUMENTO*/
      UPDATE _sv_serie_punto_venta
      SET nro_secuencia = nro_secuencia + 1
      where id_empresa  = varEmpresa
      and id_punto_venta= varPuntoVenta
      and id_tipo_doc   = varTipoDoc;
    else
      set varNumVenta = '';
      SET varError = '=> LA FECHA INGRESADA NO ES CORRECTA\n';
    end if;
  END IF; -- FIN VAR ERROR
  SELECT varError, varNumVenta, CONCAT(varTipoNom, ' : ', varNumSer, '-' , varNumSec) as documento;
END;
