DROP PROCEDURE IF EXISTS spMante_Unidad_Medida_Indicador_Detalle;
CREATE PROCEDURE spMante_Unidad_Medida_Indicador_Detalle(
	varOpcion   varchar(10),
	varCodigo   int,
  varTabla    int,
	varDesde    double,
  varHasta    double,
  varFormula  double,
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    SELECT ifnull(max(id_detalle),0)+1 INTO varCodigo 
    FROM _sind_tabla_detalle
    where id_tabla = varTabla;
    INSERT INTO _sind_tabla_detalle (id_detalle, id_tabla, rango_ini, rango_fin, formula, _date_create, _date_update, _user_create, _user_update) 
    values (varCodigo, varTabla, varDesde, varHasta, varFormula, NOW(),NOW(), varUsuario, varUsuario);
    set varError = 'OK';
   
	else
    update _sind_tabla_detalle set
    rango_ini    = varDesde,
    rango_fin    = varHasta,
    formula      = varFormula,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_tabla = varCodigo;
    set varError = 'OK';
	end if;
  select varError;
END;