call spMante_Trabajador_Empresa('EDIT',  42207450,  NULL,  NULL,  1, 4, 3, 5, 23, 
												'21',  '2010-04-25', NULL, '2010-04-26', NULL, '03', '1', '2', '02', 
												'39519467463080', '02', '30543848744012', 1450,  110, 0, 'N', 'N', 'S',           
      											'P',  '22',  '606561ABNRV0',  '8312081BRNVA008',	'N', 1);
                            
DROP PROCEDURE IF EXISTS spMante_Trabajador_Empresa;
CREATE PROCEDURE spMante_Trabajador_Empresa(
	varOpcion     varchar(10),
	varTrabajador int,          
  varEmpresa    int,             
  varTipPlani   varchar(2),
  varEstado     int,
  varAgencia    int,             
  varArea       int,        
  varSubArea    int,            
  varCargo      int,               
  varTipoTrab   varchar(5),     
  varFecIng     date,        
  varFecSal     date,           
  varFecPla     date, 
  varMotFin     varchar(2),  
  varTipContra  varchar(2),   
  varTipPeriod  varchar(2),
  varTipPago    varchar(2),           
  varBancoPago  varchar(2),
  varCuentaPago varchar(20),        
  varBancoCts   varchar(2),           
  varCuentaCts  varchar(20),         
  varRemMen     double,
  varConLabBono double,          
  varConLabViat double,       
  varFlagRet    char(1),           
  varFlagQui    char(1),
  varFlagAsiFa  char(1),
  varSistema    char(1),
  varRegimen    varchar(2),
  varNroCuspp   varchar(20),
  varNroSeguro  varchar(20),
  varSaludVida  char(1),
  varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Buscamos si el trabajador ya se encuentra registrado en la empresa y tipo de planilla
    select count(*) INTO varExiste 
    from _srh_trabajador_empresa 
    where id_trabajador   = varTrabajador
    and id_empresa        = varEmpresa
    and id_tipo_planilla  = varTipPlani
    and _estado           = 'A';
    
    if varExiste > 0 then 
      set varError = CONCAT("\nEL TRABAJADOR \t ", 
                            (select UPPER(CONCAT(id_trabajador, ' - ', apellido_paterno, ' ', apellido_materno, ' ', nombre)) from _sv_trabajador where id_trabajador=varTrabajador), 
                            "\nYA SE ENCUENTRA REGISTRADO PARA :",
                            "\nEmpresa : \t",
                            (select UPPER(CONCAT(id_empresa, ' - ', nombre)) from _sv_empresa where id_empresa = varEmpresa),
                            "\nTipo Planilla : \t",
                            (select UPPER(CONCAT(id_tipo_planilla, ' - ', nombre)) from _srh_tipo_planilla where id_tipo_planilla = varTipPlani)
                            );
      set varExiste= 0;
    end if;
    
    -- Si no se genero error insertamos el trabajador_empresa
    if varError = '' then
      set varError = 'OK';
      INSERT INTO _srh_trabajador_empresa(
                  id_trabajador,          id_empresa,             id_tipo_planilla,       id_estado_trabajador,
                  id_agencia,             id_area,                id_sub_area,            id_cargo,               
                  id_tipo_trabajador,     fecha_ingreso,          fecha_salida,           fecha_ingreso_planilla, 
                  id_tipo_cese,           id_tipo_contrato,       id_tipo_periodicidad,   id_tipo_pago,           
                  id_banco_pago,          nro_cuenta_pago,        id_banco_cts,           nro_cuenta_cts,         
                  remuneracion_mensual,   condilab_bono,          condilab_viatico,       flag_retener,           
                  flag_quinta,            flag_asigfam,           id_sistema,             id_regimen,             
                  nro_cuspp,              nro_seguro,             flag_saludvida,         
                  _date_create,           _date_update,           _user_create,           _user_update)
      VALUES (    varTrabajador,          varEmpresa,             varTipPlani,            varEstado,
                  varAgencia,             varArea,                varSubArea,             varCargo,               
                  varTipoTrab,            varFecIng,              varFecSal,              varFecPla,              
                  varMotFin,              varTipContra,           varTipPeriod,           varTipPago,