call spMante_Sistema_Rol('NEW', 0, NULL, 'DIGITADOR', 1);

DROP PROCEDURE IF EXISTS spMante_Sistema_Rol;
CREATE PROCEDURE spMante_Sistema_Rol(
	varOpcion   varchar(10),
  varSistema  int,
	varCodigo   varchar(2),
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste from _sys_rol
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A' and id_sistema = varSistema;
    if varExiste <= 0 then 
      SELECT ifnull(max(id_rol),0)+1 INTO varCodigo FROM _sys_rol where id_sistema = varSistema;
      INSERT INTO _sys_rol (id_sistema, id_rol, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varSistema, varCodigo, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL ROL DEL SISTEMA ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste from _sys_rol
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A' and id_rol <> varCodigo and id_sistema = varSistema;
    if varExiste <= 0 then 
      update _sys_rol set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_rol = varCodigo
      and id_sistema = varSistema;
    else
      set varError = CONCAT('EL ROL DEL SISTEMA ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;