call spMante_Ruta('NEW', '1B61','ELBOSQUE',1);

DROP PROCEDURE IF EXISTS spMante_Ruta;
CREATE PROCEDURE spMante_Ruta(
	varOpcion   varchar(10),
	varCodigo   varchar(10),
	varNombre   varchar(80),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    -- Verificamos que el codigo ingresado no exista
      select count(*) INTO varExiste
      from _sv_ruta
      where TRIM(UPPER(id_ruta)) = TRIM(UPPER(varCodigo))
      and _estado = 'A';
      if varExiste > 0 then
        set varError = CONCAT("EL CODIGO DE RUTA << ",UPPER(varCodigo)," >> YA SE ENCUENTRA REGISTRADO\n");
        set varExiste = 0;
      end if;
    
    -- Verificamos que el codigo ingresado no exista
      select count(*) INTO varExiste
      from _sv_ruta
      where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
      and _estado = 'A';
      if varExiste > 0 then
        if varError = 'OK' then
          set varError = CONCAT("EL NOMBRE DE RUTA << ",UPPER(varNombre)," >> YA SE ENCUENTRA REGISTRADO\n");
        else
          set varError = CONCAT(varError, "EL NOMBRE DE RUTA << ",UPPER(varNombre)," >> YA SE ENCUENTRA REGISTRADO\n");
        end if;
      end if;
      
    if varError = 'OK' then 
      INSERT INTO _sv_ruta (id_ruta, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (TRIM(UPPER(varCodigo)), TRIM(UPPER(varNombre)), NOW(),NOW(), varUsuario, varUsuario);
    end if;
	else
    select count(*) INTO varExiste
    from _sv_ruta
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and TRIM(UPPER(id_ruta)) <> TRIM(UPPER(varCodigo))
    and _estado = 'A';
    
    if varExiste <= 0 then 
      update _sv_ruta 
      set
      nombre       = TRIM(UPPER(varNombre)), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_ruta = varCodigo;
    else
      set varError = CONCAT('EL NOMBRE DE RUTA << ', varNombre, ' >> YA SE ENCUENTRA REGISTRADO\n');
    end if;
	end if;
  select varError;
END;