Call spMante_RMV('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_RMV;
CREATE PROCEDURE spMante_RMV(
	varOpcion   varchar(10),
	varCodigo   int,
  varVigencia date,
	varMonto    double,
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_rmv 
    where vigencia >= varVigencia 
    and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EXISTE UNA RMV CON VIGENCIA MAYOR A <<', date_format(varVigencia,'%d/%m/%Y'), '>>\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_rmv),0)+1 INTO varCodigo FROM _srh_rmv;
      INSERT INTO _srh_rmv (id_rmv, vigencia, monto, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varVigencia, varMonto, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_rmv 
    where vigencia >= varVigencia  
    and _estado = 'A' 
    and id_rmv <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EXISTE UNA RMV CON VIGENCIA MAYOR A <<', date_format(varVigencia,'%d/%m/%Y'), '>>\n');
    end if;
    
    if varError = '' then 
      update _srh_rmv set
      vigencia     = varVigencia,
      monto        = varMonto,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_rmv = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;