Call spMante_Punto_Venta('NEW', NULL, 'OFICINA PRINCIPAL', 'ABREV', 1);

DROP PROCEDURE IF EXISTS spMante_Punto_Venta;
CREATE PROCEDURE spMante_Punto_Venta(
	varOpcion   varchar(10),
	varCodigo   int,
	varEmpresa  int,
  varAgencia  int,
  varNombre   varchar(100),
  varAbrev    varchar(20),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Validamos que el nombre del almacen no exista
    select count(*) INTO varExiste  from _sv_punto_venta 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A'
    and id_empresa = varEmpresa
    and id_agencia = varAgencia;
    if varExiste > 0 then
      set varError = CONCAT('EL PUNTO DE VENTA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO PARA ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_punto_venta),0)+1 INTO varCodigo FROM _sv_punto_venta;
      INSERT INTO _sv_punto_venta (id_punto_venta, id_empresa, id_agencia, nombre, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varEmpresa, varAgencia, UPPER(varNombre), UPPER(varAbrev), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Validamos que el razon social de la empresa no exista
    select count(*) INTO varExiste  from _sv_punto_venta 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_punto_venta <> varCodigo 
    and id_empresa = (select id_empresa from _sv_punto_venta where id_punto_venta=varCodigo)
    and id_agencia = (select id_agencia from _sv_punto_venta where id_punto_venta=varCodigo);
    if varExiste > 0 then
      set varError = CONCAT('EL PUNTO DE VENTA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN ESTA EMPRESA\n');
    end if;
    
    if varError = '' then 
      update _sv_punto_venta set
      nombre    = UPPER(varNombre),
      abrev     = UPPER(varAbrev),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_punto_venta = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;