call spMante_Producto_Sub_Familia('NEW', NULL, 'ACEITE VEGETAL',7, 1);
call spMante_Producto_Sub_Familia('EDIT', '040302', 'INSUMO QUIMICo', '', 1);
    
DROP PROCEDURE IF EXISTS spMante_Producto_Sub_Familia;
CREATE PROCEDURE spMante_Producto_Sub_Familia(
	varOpcion   varchar(10),
	varCodigo   varchar(6),
	varNombre   varchar(80),
  varFamilia  varchar(4),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_sub_familia
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and id_sub_familia = varFamilia
    and _estado = 'A';
    if varExiste <= 0 then 
      -- Obtenemos el Codigo de la Familia
      select ifnull(max(substring(id_sub_familia,5,2)),0)+1 INTO varCodigo 
      from _sv_sub_familia 
      where id_familia = varFamilia;
      set varCodigo = CONCAT(LPAD(varFamilia,4,'0'),LPAD(varCodigo,2,'0'));
      
      INSERT INTO _sv_sub_familia (id_sub_familia, id_familia, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varFamilia, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA SUB FAMILIA DE PRODUCTO ', varNombre, ' YA SE ENCUENTRA REGISTRADA');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_sub_familia
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'
    and id_sub_familia <> varCodigo
    and id_familia = SUBSTRING(varCodigo,1,4);
    if varExiste <= 0 then 
      update _sv_sub_familia set      
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_sub_familia = varCodigo;
    else
      set varError = CONCAT('LA SUB FAMILIA DE PRODUCTO ', varNombre, ' YA SE ENCUENTRA REGISTRADA');
    end if;
	end if;
  select varError;
END;