DROP PROCEDURE IF EXISTS spMante_Producto_Familia;
CREATE PROCEDURE spMante_Producto_Familia(
	varOpcion   varchar(10),
	varCodigo   varchar(4),
  varLinea    varchar(2),
	varNombre   varchar(80),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_familia
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and id_tipo = varLinea  and _estado = 'A';
    if varExiste <= 0 then 
      -- Obtenemos el Codigo de la Familia
      select ifnull(max(substring(id_familia,3,2)),0)+1 INTO varCodigo from _sv_familia where id_tipo = varLinea;
      set varCodigo = CONCAT(LPAD(varLinea,2,'0'),LPAD(varCodigo,2,'0'));
      
      INSERT INTO _sv_familia (id_familia, id_tipo, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varLinea, UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA FAMILIA DE PRODUCTO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_familia
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and id_tipo = varLinea  and _estado = 'A'
    and id_familia <> varCodigo;
    if varExiste <= 0 then 
      update _sv_familia set
      nombre  = UPPER(varNombre), 
      _date_update = NOW(),
      _user_update = varUsuario
      where id_familia = varCodigo;
    else
      set varError = CONCAT('LA FAMILIA DE PRODUCTO ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
	end if;
  select varError;
END;