CALL spMante_Pago(1, 2, '2', 'DEP0112', '2010-10-20', 5350, 2350, 'PAGO CON DEPOSITO', 1);

DROP PROCEDURE IF EXISTS spMante_Pago;
CREATE PROCEDURE spMante_Pago(
	varCliente    int, 
  varVenta      int,
  varTipoPago   int,
	varDocumento  varchar(20),
  varFecha      date,
  varSaldo      double,
  varMonto      double,	
  varObserva    text,
  varUsuario    int
  )
BEGIN
  DECLARE varNumPago int;
  SELECT if(isnull(MAX(id_pago)),0,MAX(id_pago))+1 INTO varNumPago FROM _sv_pago; 
  
  IF varMonto = varSaldo THEN
    UPDATE _sv_venta SET estado = 'CA', saldo = saldo - varMonto, _user_update = varUsuario, _update=NOW() where id_venta = varVenta;
  ELSE
    UPDATE _sv_venta SET estado = 'PP', saldo = saldo - varMonto, _user_update = varUsuario, _update=NOW() where id_venta = varVenta;
  END IF;
  
  /*REGISTRAMOS EL VOUCHER DE PAGO*/
  insert into _sv_pago(id_pago, id_cliente, id_venta, id_forma_pago, nro_doc_pago, fecha, monto, observacion, _create, _update, _user_create, _user_update)
  values(varNumPago, varCliente, varVenta, varTipoPago, varDocumento, varFecha, varMonto, varObserva, NOW(), NOW(), varUsuario, varUsuario);
  
  /*REGISTRAMOS EL MOVIMIENTO DE LA CUENTA*/
  insert into _sv_movimiento_cuenta(id_cliente, id_venta, id_pago, tipo_mov, fecha, monto, _create, _update, _user_create, _user_update)
  values (varCliente, varVenta, varNumPago, 'PAG', varFecha, varMonto, NOW(), NOW(), varUsuario, varUsuario);
END;
