call spMante_Moneda('NEW', NULL, 'SIN EDUCACIN FORMAL', 'SIN EDUCACIN FORMAL', 1);

DROP PROCEDURE IF EXISTS spMante_Moneda;
CREATE PROCEDURE spMante_Moneda(
	varOpcion   varchar(10),
	varCodigo   varchar(5),
	varNombre   varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_moneda 
    where _estado = 'A'
    and (TRIM(UPPER(id_moneda)) = TRIM(UPPER(varCodigo)) or TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)));
    
    if varExiste > 0 then
      set varError = CONCAT('LA MONEDA <<', UPPER(varCodigo), ' - ', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      INSERT INTO _srh_moneda (id_moneda, nombre, _date_create, _date_update, _user_create, _user_update) 
      values (UPPER(varCodigo), UPPER(varNombre), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_moneda 
    where _estado = 'A' and id_moneda <> varCodigo
    and (TRIM(UPPER(id_moneda)) = TRIM(UPPER(varCodigo)) or TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)));
    if varExiste > 0 then
      set varError = CONCAT('LA MONEDA <<', UPPER(varCodigo), ' - ', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_moneda set
      nombre       = UPPER(varNombre),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_moneda = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;