call spMante_Habitacion('EDIT', 1, 1, 2, 1, '000102', '101', 25, NULL, 1, 'D', 
									 	'N', 'N', 'N', 'N', 'N', 'A', 1);

DROP PROCEDURE IF EXISTS spMante_Habitacion;
CREATE PROCEDURE spMante_Habitacion(
	varOpcion     varchar(10),
	varCodigo     int,	
	varEmpresa    int,
  varPiso       int,
  varTipoHab    int,
  varProducto   varchar(6),
	varNumero     varchar(20),
	varPrecio     double,
	varCapacidad  int,
  varCamas      int,
  varJacuzzi    char(1),
  varTeve       char(1),
  varAire       char(1),
  varTerma      char(1),
  varRadio      char(1),
  varFrioBar    char(1),
  varEstado     char(1),
	varUsuario    int
)
BEGIN  
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  if varProducto is not null then
    set varProducto = lpad(varProducto, 6,'0');
  end if;
	if varOpcion='NEW' then
    -- Buscamos si el numero del cliente ya se encuentra registrado
    select count(*) INTO varExiste from _sh_habitacion 
    where TRIM(UPPER(numero)) = TRIM(UPPER(varNumero)) 
    and id_empresa  = varEmpresa
    and _estado     = 'A';
    
    if varExiste <= 0 then 
      -- Generamos Siguiente Correlativo
      SELECT ifnull(max(id_habitacion),0)+1 INTO varCodigo FROM _sh_habitacion;    
      -- Insertamos Registro
      insert into _sh_habitacion (id_habitacion, id_empresa, id_piso, id_tipo_habitacion, id_producto, numero, precio, 
                                  num_personas, num_camas, flag_jacuzzi, flag_tv, flag_aire, flag_terma, flag_radio,
                                  flag_friobar, estado, _date_create, _date_update, _user_create, _user_update) 
      VALUES (varCodigo, varEmpresa, varPiso, varTipoHab, varProducto, varNumero, varPrecio, varCapacidad,
              varCamas, varJacuzzi, varTeve, varAire, varTerma, varRadio, varFrioBar, varEstado,
              NOW(), NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA HABITACION ', varNumero, ' YA SE ENCUENTRA REGISTRADA PARA ESTA EMPRESA');
    end if;
    
	else
    -- Buscamos si el numero del cliente ya se encuentra registrado
    select count(*) INTO varExiste  from _sh_habitacion
    where TRIM(UPPER(numero)) = TRIM(UPPER(varnumero))
    and _estado       = 'A'  
    and id_habitacion <> varCodigo
    and id_empresa    = varEmpresa;
    if varExiste <= 0 then 
      update _sh_habitacion set		
      id_piso             = varPiso, 
      id_tipo_habitacion  = varTipoHab, 
      id_producto         = varProducto, 
      numero              = varNumero, 
      precio              = varPrecio, 
      num_personas        = varCapacidad,
      num_camas           = varCamas, 
      flag_jacuzzi        = varJacuzzi, 
      flag_tv             = varTeve, 
      flag_aire           = varAire,
      flag_terma          = varTerma, 
      flag_radio          = varRadio,
      flag_friobar        = varFrioBar, 
      estado              = varEstado,
      _date_update        = NOW(),
      _user_update        = varUsuario
      where id_habitacion = varCodigo;
    else
      set varError = CONCAT('LA HABITACION ', varNumero, ' YA SE ENCUENTRA REGISTRADA PARA ESTA EMPRESA');
    end if;		
	end if;
  select varError;
END;